/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8230.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8230.DeviceView.ChassisLike;
import ibm.nways.jdm8230.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8230.DeviceView.ModuleLike;
import ibm.nways.ras.RAS;
import java.awt.Point;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class Module
implements ModuleLike {
    protected int numberOfPorts;
    protected String backgroundGif = "";
    protected GraphicImage moduleGraphicImage;
    protected int modType;
    protected Point location;
    protected int slot;
    protected GraphicContainer graphicContainer;
    protected GraphicContainer moduleContainer = new GraphicContainer();
    private Vector components = new Vector();
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8230.DeviceView.GraphicResources";
    protected static ResourceBundle resources = ResourceBundle.getBundle("ibm.nways.jdm8230.DeviceView.GraphicResources");
    protected static final String SER_PATH = "ibm.nways.jdm8230.WCDefault";
    protected static final String DEST_PANEL = "ibm.nways.jdm8230.eui.ModulesPanel";
    protected static final int COOKIE_FLAGS = 20;
    protected String cookieID;
    protected GenModel modTableModel;
    protected GenModel portTableModel;
    protected JdmBrowser jdmBrowser;
    protected ChassisLike chassis;
    public static final int UNKNOWN = 0;
    public static final int LAM = 1;
    public static final int ICS = 2;
    public static final int UTP_ACTIVE = 3;
    public static final int UTP_PASSIVE = 4;
    public static final int RI_RO = 5;
    public static final int RLIU = 6;
    protected static final String[] MODULE_TYPE = new String[]{"Module_Unknown", "Module_LAM", "Module_ICS", "Module_Utp_Active", "Module_Utp_Passive", "Module_RI_RO", "Module_RLIU"};

    public void dispose() {
        if (this.graphicContainer != null) {
            this.graphicContainer.dispose();
            this.graphicContainer = null;
        }
        if (this.moduleContainer != null) {
            this.moduleContainer.dispose();
            this.moduleContainer = null;
        }
        this.moduleGraphicImage = null;
        this.location = null;
        this.modTableModel = null;
        this.portTableModel = null;
        this.jdmBrowser = null;
        this.chassis = null;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.components.removeAllElements();
    }

    public void draw() {
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            try {
                leafCompositeLike.draw();
            }
            catch (Exception exception) {
                RAS.logInformation(19, 4, this, "draw", "Exception drawing object -> " + leafCompositeLike.getClass().getName());
                RAS.logException(19, 4, this, "draw", exception);
            }
        }
        this.graphicContainer.add(this.moduleContainer);
    }

    public final void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public GenModel getModel() {
        block2: {
            if (this.modTableModel != null) break block2;
            try {
                GenModel genModel = (GenModel)this.jdmBrowser.getModel();
                genModel = (GenModel)genModel.getComponent("ConfigurationFolder");
                genModel = (GenModel)genModel.getComponent("SystemFolder");
                genModel = (GenModel)genModel.getComponent("DeviceFolder");
                this.modTableModel = (GenModel)genModel.getComponent("ModuleFolder");
            }
            catch (Exception exception) {
                RAS.logException(19, 4, this, "getModel", exception);
            }
        }
        return this.modTableModel;
    }

    public ModelInfo getModelInfo() {
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.CauModLocation", new Integer(this.slot));
        return modelInfo;
    }

    public String getDestinationPanel() {
        return DEST_PANEL;
    }

    public final void setCommonInformation(ChassisLike chassisLike, JdmBrowser jdmBrowser, GenModel genModel, GenModel genModel2, int n, GraphicContainer graphicContainer) {
        this.chassis = chassisLike;
        this.jdmBrowser = jdmBrowser;
        this.modTableModel = genModel;
        this.portTableModel = genModel2;
        this.slot = n;
        this.graphicContainer = graphicContainer;
    }

    public I18NMsgFormat getFlyOverText() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(this.slot);
        String string = "Module_Unknown";
        try {
            string = MODULE_TYPE[this.modType];
        }
        catch (Exception exception) {
            RAS.logWarning(19, 4, this, "getFlyOverText", "Cannot find fly-over for module type -> " + this.modType);
            RAS.logException(19, 4, this, "getFlyOverText", exception);
        }
        objectArray[1] = resources.getString(string);
        return new I18NMsgFormat(BUNDLE_NAME, "Module", objectArray);
    }

    public void setSpecificInformation() {
    }

    public void discoverChildren() {
    }

    public final void setLocation(Point point) {
        this.location = point;
        this.moduleContainer.setLocation(this.location.x, this.location.y);
    }
}

